/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.datax;

/**
 * Interface to specify a generic push source. A push source pushes
 * data to the destination whenever it is ready.
 */
public interface Source extends Statistics, Properties 
{
	/**
	 * Interface to start the source.
	 */
	public void start();
	
	/**
	 * Interface to mute the source.
	 * @param mode true for muting and false for resuming
	 */
	public boolean mute(boolean mode);
	
	/**
	 * Interface for closing the source.
	 */
	public void close() ;   
}
